#!/usr/bin/perl
# #
#   @app                ConfigServer Firewall & Security (CSF)
#                       Login Failure Daemon (LFD)
#   @website            https://configserver.dev
#   @docs               https://docs.configserver.dev
#   @download           https://download.configserver.dev
#   @repo               https://github.com/Aetherinox/csf-firewall
#   @copyright          Copyright (C) 2025-2026 Aetherinox
#                       Copyright (C) 2006-2025 Jonathan Michaelson
#                       Copyright (C) 2006-2025 Way to the Web Ltd.
#   @license            GPLv3
#   @updated            09.26.2025
#   
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or (at
#   your option) any later version.
#   
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, see <https://www.gnu.org/licenses>.
# #

sub custom_line
{
	my $line = shift;
	my $lgfile = shift;

# #
#   Do not edit before this point
#   ##############################################################################
#   
#   Custom regex matching can be added to this file without it being
#   overwritten by csf upgrades. The format is slightly different from
#   regex.pm to cater for additional parameters. You must specify the log
#   file that needs to be scanned for log line matches in csf.conf under
#   CUSTOMx_LOG. You can scan up to 9 custom logs (CUSTOM1_LOG .. CUSTOM9_LOG)
#
#   The regex matches in this file will supersede the matches in regex.pm
#
#   Example:
#       if (($globlogs{CUSTOM1_LOG}{$lgfile}) and ($line =~ /^\S+\s+\d+\s+\S+ \S+ pure-ftpd: \(\?\@(\d+\.\d+\.\d+\.\d+)\) \[WARNING\] Authentication failed for user/)) {
#           return ("Failed myftpmatch login from",$1,"myftpmatch","5","20,21","1","0");
#       }
#
#   The return values from this example are as follows:
#
#       "Failed myftpmatch login from" = text for custom failure message
#       $1 = the offending IP address
#       "myftpmatch" = a unique identifier for this custom rule, must be
#           alphanumeric and have no spaces
#       "5" = the trigger level for blocking
#       "20,21" = the ports to block the IP from in a comma-separated list,
#           only used if LF_SELECT enabled. To specify the protocol use
#           53;udp,53;tcp
#       "1" = n/temporary (n = number of seconds to temporarily block) or
#           1/permanent IP block, only used if LF_TRIGGER is disabled
#       "0" = whether to trigger Cloudflare block if CF_ENABLE is set.
#           "0" = disable, "1" = enable
# #

# #
#   If the matches in this file are not syntactically correct for perl then
#   lfd will fail with an error. You are responsible for the security of any
#   regex expressions you use. Remember that log file spoofing can exploit
#   poorly constructed regexes.
#   
#   ###############################################################
#   Do not edit beyond this point
# #

	return 0;
}

1;
